/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.lootjournal.fabric;

import dev.obscuria.lootjournal.LootJournal;
import dev.obscuria.lootjournal.ModConfig;
import dev.obscuria.lootjournal.ModConfigDefaults;
import dev.obscuria.lootjournal.client.ItemPolicy;
import dev.obscuria.lootjournal.client.render.Anchor;
import dev.obscuria.lootjournal.client.render.PickupDrawStyle;
import java.util.List;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.ConfigHolder;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import me.shedaniel.autoconfig.serializer.Toml4jConfigSerializer;
import net.minecraft.class_1269;
import org.apache.commons.compress.utils.Lists;

@Config(name="obscuria/loot_journal-client")
public final class FabricConfig
implements ConfigData {
    @ConfigEntry.Gui.CollapsibleObject
    public Display display = new Display();
    @ConfigEntry.Gui.CollapsibleObject
    public Layout layout = new Layout();
    @ConfigEntry.Gui.CollapsibleObject
    public Filter filter = new Filter();

    public static void init() {
        ConfigHolder configHolder = AutoConfig.register(FabricConfig.class, Toml4jConfigSerializer::new);
        configHolder.registerLoadListener(FabricConfig::onUpdate);
        configHolder.registerSaveListener(FabricConfig::onUpdate);
        configHolder.load();
    }

    public static class_1269 onUpdate(ConfigHolder<FabricConfig> holder, FabricConfig config) {
        LootJournal.CONFIG.style = config.display.style;
        LootJournal.CONFIG.itemEntryDisplay = config.display.itemEntry.display;
        LootJournal.CONFIG.itemEntryDisplayTotalAmount = config.display.itemEntry.displayTotalAmount;
        LootJournal.CONFIG.itemEntryUseItemFormatting = config.display.itemEntry.useItemFormatting;
        LootJournal.CONFIG.itemEntryStyle = ModConfig.createStyle(config.display.itemEntry.color, config.display.itemEntry.italic);
        LootJournal.CONFIG.aggregatedEntryDisplay = config.display.aggregatedEntry.display;
        LootJournal.CONFIG.aggregatedEntryStyle = ModConfig.createStyle(config.display.aggregatedEntry.color, config.display.aggregatedEntry.italic);
        LootJournal.CONFIG.experienceEntryDisplay = config.display.experienceEntry.display;
        LootJournal.CONFIG.experienceEntryStyle = ModConfig.createStyle(config.display.experienceEntry.color, config.display.experienceEntry.italic);
        LootJournal.CONFIG.anchor = config.layout.anchor;
        LootJournal.CONFIG.anchorPixelOffset = config.layout.anchorPixelOffset;
        LootJournal.CONFIG.anchorPercentOffset = config.layout.anchorPercentOffset;
        LootJournal.CONFIG.scale = config.layout.scale;
        LootJournal.CONFIG.separation = config.layout.separation;
        LootJournal.CONFIG.lifetime = config.layout.lifetime;
        LootJournal.CONFIG.displayCapacity = config.layout.displayCapacity;
        LootJournal.CONFIG.queueCapacity = config.layout.queueCapacity;
        LootJournal.CONFIG.defaultItemPolicy = config.filter.defaultItemPolicy;
        LootJournal.CONFIG.itemIdBlacklist = ModConfig.mapItems(config.filter.itemIdBlacklist);
        LootJournal.CONFIG.itemIdWhitelist = ModConfig.mapItems(config.filter.itemIdWhitelist);
        LootJournal.CONFIG.modIdBlacklist = config.filter.modIdBlacklist;
        LootJournal.CONFIG.modIdWhitelist = config.filter.modIdWhitelist;
        return class_1269.field_5812;
    }

    public static final class Display {
        @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
        public PickupDrawStyle style = ModConfigDefaults.STYLE;
        @ConfigEntry.Gui.CollapsibleObject
        public ItemEntry itemEntry = new ItemEntry();
        @ConfigEntry.Gui.CollapsibleObject
        public AggregatedEntry aggregatedEntry = new AggregatedEntry();
        @ConfigEntry.Gui.CollapsibleObject
        public ExperienceEntry experienceEntry = new ExperienceEntry();

        public static final class ItemEntry {
            public boolean display = true;
            public boolean displayTotalAmount = true;
            public boolean useItemFormatting = true;
            @ConfigEntry.ColorPicker
            public int color = 0xFFFFFF;
            public boolean italic = false;
        }

        public static final class AggregatedEntry {
            public boolean display = true;
            @ConfigEntry.ColorPicker
            public int color = 0xFFFFFF;
            public boolean italic = true;
        }

        public static final class ExperienceEntry {
            public boolean display = true;
            @ConfigEntry.ColorPicker
            public int color = 0x55FF55;
            public boolean italic = false;
        }
    }

    public static final class Layout {
        @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
        public Anchor anchor = Anchor.BOTTOM_RIGHT;
        @ConfigEntry.BoundedDiscrete(min=0L, max=200L)
        public int anchorPixelOffset = 3;
        @ConfigEntry.BoundedDiscrete(min=0L, max=50L)
        public int anchorPercentOffset = 10;
        @ConfigEntry.BoundedDiscrete(min=50L, max=100L)
        public int scale = 100;
        @ConfigEntry.BoundedDiscrete(min=0L, max=16L)
        public int separation = 3;
        @ConfigEntry.BoundedDiscrete(min=0L, max=32L)
        public int lifetime = 6;
        @ConfigEntry.BoundedDiscrete(min=1L, max=64L)
        public int displayCapacity = 9;
        @ConfigEntry.BoundedDiscrete(min=0L, max=256L)
        public int queueCapacity = 9;
    }

    public static final class Filter {
        @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
        public ItemPolicy defaultItemPolicy = ModConfigDefaults.DEFAULT_ITEM_POLICY;
        public List<String> itemIdBlacklist = Lists.newArrayList();
        public List<String> itemIdWhitelist = Lists.newArrayList();
        public List<String> modIdBlacklist = Lists.newArrayList();
        public List<String> modIdWhitelist = Lists.newArrayList();
    }
}

